//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 19 textures and 230 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 02/26/1998    (26.02.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     30.0
  color <0.6,0.6,0.6,0.0,0.498039>
  turbulence   <0.3,0.2,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.0
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

camera {  //  Camera Camera01
  location  <204.600, -319.200, 20.500>
  direction <0.0,     0.0,  1.6095>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <99.870, -19.267, 54.255>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <0.000, -0.100, 0.000>
  direction <0.0,     0.0,  1.8660>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <-3.300, 1.500, 151.700>
  color rgb <1.000, 0.920, 0.750>
}

light_source {   // Light2
  <235.500, -334.500, 23.600>
  color rgb <0.250, 0.250, 0.250>
  shadowless
  atmosphere off
}

light_source { // Moonlight
  <107.300, 359.300, 258.900>
  color  rgb<0.282, 0.282, 0.384>
  area_light <0.974, 1.745, 0.087>, <-158.529, 92.504, -79.445>, 3, 3
  adaptive 1
  jitter
  atmosphere off
}



//
// ********  TEXTURES  *******
//

#include "finished lighthouse.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Plank1 = object {
  box { // Plank1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Wood
    }
    scale <0.3, 13.0, 0.1>
    rotate 12.5*x
    translate  <202.8, -324.4, 16.7>
  }
}


#declare Floors = union {
  box { // base
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Red_Granite
    }
    scale <16.5, 16.5, 5.5>
    translate  15.1*z
  }
  box { // RunningEdge1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <17.0, 17.0, 0.255>
    translate  20.9*z
  }
}
#declare EdgePost1 = union {
  sphere { // EdgeTop
    <0,0,0>,1
    scale 1.6
    translate  <-16.2, 16.2, 110.0>
  }
  cylinder { // Tier1Edge
    <0,0,1>, <0,0,0>, 1 
    texture {
      White_Plaster
    }
    scale <1.6, 1.6, 100.0>
    translate  <-16.2, 16.2, 10.0>
  }
  cylinder { // Tier1EdgeHz
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 32.0>
    rotate 90.0*x
    translate  <-16.2, 16.2, 110.0>
  }
  texture {
    White_Plaster
  }
}
#declare WindowCutters5 = union {
  cylinder { // WindowTop2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm2
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  rotate -90.0*z
  translate  <-494.2, 32.5, 25.7>
}
#declare WindowCutters1 = union {
  cylinder { // WindowTop1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm1
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  translate  <-33.0, -494.0, 25.8>
}
#declare WindowCutters10 = object {
  object { // WindowCutters10->WindowCutters5
    WindowCutters5
    rotate <0.0, 0.0, -0.0>
    translate  57.5*z
  }
}
#declare WindowCutters12 = object {
  object { // WindowCutters12->WindowCutters1
    WindowCutters1
    rotate -0.0*y
    translate  57.5*z
  }
}
#declare WindowCutters13 = union {
  cylinder { // WindowTop3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm3
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  rotate -90.0*z
  translate  <-494.2, 54.5, 25.7>
}
#declare WindowCutters18 = object {
  object { // WindowCutters18->WindowCutters13
    WindowCutters13
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, 0.0, 57.5>
  }
}
#declare WindowCutters19 = union {
  cylinder { // WindowTop4
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm4
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  translate  <-54.0, -494.0, 25.8>
}
#declare WindowCutters40 = union {
  cylinder { // WindowTop10
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm10
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  translate  <-43.5, -494.0, 25.8>
}
#declare WindowCutters31 = union {
  cylinder { // WindowTop7
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm7
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  rotate -90.0*z
  translate  <-494.2, 43.5, 25.7>
}


#declare TowerEdg1 = object {
  box { // TowerEdg1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.65, 0.65, 1.0>
    translate  <58.7, 34.4, 9.3>
  }
}
#declare WallTower1 = union { // WallTower1
  box { // TowerBase1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <3.0, 3.0, 4.0>
    translate  <56.7, 32.4, 4.3>
  }
  object { TowerEdg1 }
  object { // TowerEdge2->TowerEdg1
    TowerEdg1
    translate  -4.0*y
  }
  object { // TowerEdge4->TowerEdg1
    TowerEdg1
    translate  <-4.0, -3.9, 0.0>
  }
  object { // TowerEdge3->TowerEdg1
    TowerEdg1
    translate  -4.0*x
  }
  box { // Wall1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <1.692308, 53.846157, 2.307692>
    translate  <56.6, -24.0, 2.6>
  }
  box { // TowerEdg2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.5, 0.5, 1.0>
    translate  <58.7, 32.4, 9.3>
  }
  box { // TowerEdg3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.5, 0.5, 1.0>
    translate  <56.6, 34.4, 9.3>
  }
  box { // TowerEdg4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.5, 0.5, 1.0>
    translate  <56.5, 30.4, 9.3>
  }
  box { // TowerEdg5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale <0.5, 0.5, 1.0>
    translate  <54.7, 32.5, 9.3>
  }
  scale 1.3
  translate  <0.7, 27.8, -3.4>
}


#declare RailPost = object {
  cylinder { // RailPost
    <0,0,1>, <0,0,0>, 1 
    texture {
      PittedBrass_Metal
    }
    scale <0.09, 0.09, 1.0>
    translate  <218.5, -331.7, 3.5>
  }
}


#declare Mirror = object {
  sphere { // Mirror
    <0,0,0>,1
    scale <2.5, 2.5, 3.0>
    rotate <-0.0, 0.0, -0.000002>
    translate  <-4.699999, -3.699999, 148.199996>
  }
}


#declare StairCut1 = object {
  box { // StairCut1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 4.0>
    translate  <-5.1, -32.8, 13.4>
  }
}


#declare TopRoomPost1 = object {
  cylinder { // TopRoomPost1
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 13.0>
    rotate -135.0*z
    translate  10.6*y
  }
}
#declare Chimney1 = object {
  cylinder { // Chimney1
    <0,0,1>, <0,0,0>, 1 
    texture {
      White_Plaster
    }
    scale <0.3, 0.3, 3.5>
    rotate 44.0*x
    translate  <-2.0, -8.0, 14.3>
  }
}


#declare Oct1 = object {
  box { // Oct1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Red_Granite
    }
    scale <1.0, 5.4, 13.0>
    translate  <-12.4, 0.0, 122.5>
  }
}




//
// ********  OBJECTS  *******
//

object { // Plank5->Plank1
  Plank1
  rotate <0.0, -0.0, 0.0>
  translate  <2.44, 0.0, -0.0>
}


object { // Plank4->Plank1
  Plank1
  rotate <0.0, -0.0, 0.0>
  translate  <1.83, 0.0, -0.0>
}


object { // Plank3->Plank1
  Plank1
  rotate <0.0, -0.0, 0.0>
  translate  <1.22, 0.0, -0.0>
}


object { // Plank2->Plank1
  Plank1
  rotate <0.0, -0.0, 0.0>
  translate  <0.61, 0.0, -0.0>
}


object { Plank1 }




cone { // LightCone
  <0,0,0>, 0.2, <0,0,1>, 1.0
  open
  texture {
    FoggyLight
  }
  scale <25.0, 25.0, 300.0>
  rotate <97.0, -11.206504, 64.902611>
  translate  <-4.7, 2.0, 149.7>
}


#declare Tower = union {
  object { // Floors8->Floors
    Floors
    translate  92.0*z
  }
  object { // Floors7->Floors
    Floors
    translate  80.5*z
  }
  object { // Floors6->Floors
    Floors
    translate  69.0*z
  }
  object { // Floors5->Floors
    Floors
    translate  57.5*z
  }
  object { // Floors4->Floors
    Floors
    translate  46.0*z
  }
  object { // Floors3->Floors
    Floors
    translate  34.5*z
  }
  object { // Floors2->Floors
    Floors
    translate  23.0*z
  }
  object { // Floors1->Floors
    Floors
    translate  11.5*z
  }
  object { Floors }
  object { // EdgePost4->EdgePost1
    EdgePost1
    rotate -90.0*z
  }
  object { // EdgePost3->EdgePost1
    EdgePost1
    rotate -180.0*z
  }
  object { // EdgePost2->EdgePost1
    EdgePost1
    rotate 90.0*z
  }
  object { EdgePost1 }
}
#declare WindowCutters39 = union {
  cylinder { // WindowTop9
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm9
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  translate  <-49.0, -494.0, 25.8>
}
#declare WindowCutters38 = union {
  cylinder { // WindowTop8
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm8
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  translate  <-38.0, -494.0, 25.8>
}
#declare WindowCutters30 = union {
  cylinder { // WindowTop6
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm6
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  rotate -90.0*z
  translate  <-494.2, 49.0, 25.7>
}
#declare WindowCutters29 = union {
  cylinder { // WindowTop5
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate <90.0, -90.0, 0.0>
    translate  <43.5, 27.7, 1.0>
  }
  box { // WindowBtm5
    <-1, -1, -1>, <1, 1, 1>
    translate  <43.5, 26.7, 0.0>
  }
  texture {
    Black
  }
  scale <1.0, 18.5, 1.0>
  rotate -90.0*z
  translate  <-494.2, 38.1, 25.7>
}
#declare Cutters = union {
  object { WindowCutters5 }
  object { WindowCutters1 }
  object { // WindowCutters6->WindowCutters5
    WindowCutters5
    rotate <0.0, 0.0, -0.0>
    translate  11.5*z
  }
  object { // WindowCutters7->WindowCutters5
    WindowCutters5
    rotate <0.0, 0.0, -0.0>
    translate  23.0*z
  }
  object { // WindowCutters8->WindowCutters5
    WindowCutters5
    rotate <0.0, 0.0, -0.0>
    translate  34.5*z
  }
  object { // WindowCutters9->WindowCutters5
    WindowCutters5
    rotate <0.0, 0.0, -0.0>
    translate  46.0*z
  }
  object { WindowCutters10 }
  object { // WindowCutters2->WindowCutters1
    WindowCutters1
    rotate -0.0*y
    translate  11.5*z
  }
  object { // WindowCutters3->WindowCutters1
    WindowCutters1
    rotate -0.0*y
    translate  23.0*z
  }
  object { // WindowCutters4->WindowCutters1
    WindowCutters1
    rotate -0.0*y
    translate  34.5*z
  }
  object { // WindowCutters11->WindowCutters1
    WindowCutters1
    rotate -0.0*y
    translate  46.0*z
  }
  object { WindowCutters12 }
  object { WindowCutters13 }
  object { // WindowCutters14->WindowCutters13
    WindowCutters13
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, 0.0, 11.5>
  }
  object { // WindowCutters15->WindowCutters13
    WindowCutters13
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, 0.0, 23.0>
  }
  object { // WindowCutters16->WindowCutters13
    WindowCutters13
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, 0.0, 34.5>
  }
  object { // WindowCutters17->WindowCutters13
    WindowCutters13
    rotate <-0.0, 0.0, -0.0>
    translate  <-0.0, 0.0, 46.0>
  }
  object { WindowCutters18 }
  object { WindowCutters19 }
  object { // WindowCutters20->WindowCutters19
    WindowCutters19
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 11.5>
  }
  object { // WindowCutters21->WindowCutters19
    WindowCutters19
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 23.0>
  }
  object { // WindowCutters22->WindowCutters19
    WindowCutters19
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 34.5>
  }
  object { // WindowCutters23->WindowCutters19
    WindowCutters19
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 46.0>
  }
  object { // WindowCutters24->WindowCutters19
    WindowCutters19
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 57.5>
  }
  object { // WindowCutters25->WindowCutters19
    WindowCutters19
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 69.0>
  }
  object { // WindowCutters26->WindowCutters12
    WindowCutters12
    translate  <0.0, 0.0, 11.5>
  }
  object { // WindowCutters27->WindowCutters18
    WindowCutters18
    translate  <0.0, 0.0, 11.5>
  }
  object { // WindowCutters28->WindowCutters10
    WindowCutters10
    rotate 0.0*z
    translate  <0.0, 0.0, 11.5>
  }
  object { // WindowCutters46->WindowCutters40
    WindowCutters40
    translate  69.0*z
  }
  object { // WindowCutters36->WindowCutters31
    WindowCutters31
    rotate <-0.0, 0.0, -0.0>
    translate  57.5*z
  }
  object { // WindowCutters45->WindowCutters40
    WindowCutters40
    translate  57.5*z
  }
  object { // WindowCutters44->WindowCutters40
    WindowCutters40
    translate  46.0*z
  }
  object { // WindowCutters43->WindowCutters40
    WindowCutters40
    translate  34.5*z
  }
  object { // WindowCutters42->WindowCutters40
    WindowCutters40
    translate  23.0*z
  }
  object { // WindowCutters41->WindowCutters40
    WindowCutters40
    translate  11.5*z
  }
  object { WindowCutters40 }
  object { WindowCutters39 }
  object { WindowCutters38 }
  object { // WindowCutters37->WindowCutters31
    WindowCutters31
    rotate <-0.0, 0.0, -0.0>
    translate  69.0*z
  }
  object { // WindowCutters35->WindowCutters31
    WindowCutters31
    rotate <-0.0, 0.0, -0.0>
    translate  46.0*z
  }
  object { // WindowCutters34->WindowCutters31
    WindowCutters31
    rotate <-0.0, 0.0, -0.0>
    translate  34.5*z
  }
  object { // WindowCutters33->WindowCutters31
    WindowCutters31
    rotate <-0.0, 0.0, -0.0>
    translate  23.0*z
  }
  object { // WindowCutters32->WindowCutters31
    WindowCutters31
    rotate <-0.0, 0.0, -0.0>
    translate  11.5*z
  }
  object { WindowCutters31 }
  object { WindowCutters30 }
  object { WindowCutters29 }
}
difference { // Windows
  object { Tower }
  object { Cutters }
}


cone { // Funnel
  <0,0,0>, 0.6, <0,0,1>, 1.0
  texture {
    Brass_Metal
  }
  scale <5.3, 5.3, 1.8>
  rotate -180.0*x
  translate  <-1.5, 0.0, 157.6>
}


difference { // FrontWall
  object { // WallTower2->WallTower1
    WallTower1
    rotate -90.0*z
    translate  4.2*x
  }
  box { // Door
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Plaster
    }
    scale 3.7
    translate  <0.4, -74.0, -0.2>
  }
}


object { // WallTower4->WallTower1
  WallTower1
  rotate -180.0*z
  translate  <4.5, -4.7, 0.0>
}


object { // WallTower3->WallTower1
  WallTower1
  rotate 90.0*z
  translate  -4.3*y
}


object { WallTower1 }


object { // Fire
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.490946, 7.249985>, <0.000000, -1.000000, 0.000000>, <1.296288, -2.488884, 8.242612>, 
      <-2.000000, -0.679406, 5.605096>, <-1.000000, -0.679406, 5.605096>, <0.296288, -1.488884, 8.242612>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 0.320594, 5.605096>, <-1.000000, 0.320594, 5.605096>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    FlameBall
  }
  no_shadow
  hollow
  scale <1.0, 2.0, 1.5>
  rotate <-180.0, -0.0, 40.0>
  translate  <-1.2, -0.8, 151.5>
}


union { // Boat
  cone { // Prow
    <0,0,0>, 0.4, <0,0,1>, 1.0
    texture {
      DarkOak
    }
    scale <1.0, 0.6, 14.5>
    rotate 100.0*x
    translate  <219.5, -315.9, 6.0>
  }
  torus { // Rail
    2.075, 0.175  rotate -x*90
    texture {
      DMFLightOak
    }
    scale <3.1, -14.2, 4.0>
    rotate <5.0, -0.0, -0.0>
    translate  <219.4, -360.6, 0.8>
  }
  cylinder { // Mast
    <0,0,1>, <0,0,0>, 1 
    texture {
      DarkOak
    }
    scale <1.3, 1.3, 23.0>
    rotate <-10.0, -0.0, -10.0>
    translate  <219.073284, -361.391249, 0.40178>
  }
  cone { // Prow1
    <0,0,0>, 0.41, <0,0,1>, 0.8
    texture {
      PittedBrass_Metal
    }
    scale <1.0, 0.6, 6.3>
    rotate 100.0*x
    translate  <219.5, -315.9, 6.0>
  }
  torus { // BrassRail
    2.225, 0.025  rotate -x*90
    texture {
      PittedBrass_Metal
    }
    scale <2.9, -13.283872, 3.741936>
    rotate <5.0, -0.0, -0.0>
    translate  <219.4, -360.6, 2.0>
  }
  object { RailPost }
  sphere { // Ram
    <0,0,0>,1
    texture {
      PittedBrass_Metal
    }
    scale 0.8
    translate  <219.5, -315.8, 6.0>
  }
  object { // RailPost1->RailPost
    RailPost
    rotate <-0.0, -0.0, 0.0>
    translate  <-1.0, -1.0, -0.1>
  }
  object { // RailPost2->RailPost
    RailPost
    rotate <-0.0, -0.0, 0.0>
    translate  <1.5, -0.1, 0.0>
  }
  rotate <8.0, 0.0, -0.0>
  translate  <-14.6, 16.2, 61.9>
}


#declare Cape = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.664331, -1.642675, -0.259873>, <-1.000000, -1.675159, 0.021656>, <0.000000, -1.675159, 0.021656>, <-0.013210, -1.675159, -0.320999>, 
      <-1.671170, -1.000000, 1.098722>, <-0.835585, -1.000000, 0.549361>, <0.000000, -1.000000, 0.000000>, <-0.013210, -1.000000, -0.342655>, 
      <-1.671170, 0.000000, 1.098722>, <-0.835585, 0.000000, 0.549361>, <0.000000, 0.000000, 0.000000>, <-0.013210, 0.000000, -0.342655>, 
      <-1.664331, 1.249045, -0.703822>, <-1.000000, 0.610191, -0.032484>, <0.000000, 0.610191, -0.032484>, <-0.013210, 0.610191, -0.375139>
    }
  }
  scale <5.2, 1.6, 2.05>
  rotate <-0.0, -75.0, 0.0>
  translate  <-0.95, 1.55, 169.4>
}
union { // Statue
  cylinder { // Left_Arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    rotate <-151.170135, 40.510838, -99.509521>
    translate  <0.1, 2.3, 168.1>
  }
  cylinder { // Right_Arm
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    rotate <-35.4263, 58.005341, -62.183838>
    translate  <-0.2, -0.7, 168.2>
  }
  cylinder { // Right_Leg
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    rotate -20.0*x
    translate  <0.0, -1.7, 159.5>
  }
  sphere { // Head
    <0,0,0>,1
    translate  <0.0, 1.1, 170.2>
  }
  sphere { // Body
    <0,0,0>,1
    scale <1.0, 1.9, 2.5>
    translate  <0.0, 0.9, 166.9>
  }
  sphere { // Butt
    <0,0,0>,1
    scale <1.0, 1.6, 0.8>
    translate  <0.0, 0.8, 164.4>
  }
  cylinder { // Left_Leg
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 5.0>
    rotate 20.0*x
    translate  <0.0, 3.7, 159.7>
  }
  object { Cape }
  texture {
    Brass_Metal
  }
  scale 1.2
  rotate <-0.0, -0.0, 90.0>
  translate  <-0.1, 0.2, -32.3>
}


#declare Hollow_Mirror = difference {
  object { Mirror }
  object { // Mirror1->Mirror
    Mirror
    scale 0.95
    rotate -0.0*z
    translate  <-0.2, -0.2, 7.4>
  }
  rotate <-3.350348, -3.713609, 42.108646>
  translate  <8.5, 1.9, -0.4>
}
intersection { // CutMirror
  box { // MirrorCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.7, 3.0, 4.0>
    translate  <-7.5, -3.7, 148.0>
  }
  object { Hollow_Mirror }
  texture {
    GoldenLight
  }
  scale 1.5
  rotate <-0.0, 5.0, -22.0>
  translate  <-12.6, 12.1, -70.9>
}


object { // Mound
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.952646, -0.121867>, <-1.000000, -2.952646, -0.121867>, <0.000000, -2.952646, -0.121867>, <2.388534, -3.378164, -0.121867>, 
      <-2.018834, -0.794268, 0.309815>, <-1.000000, -3.403601, 0.915719>, <0.000000, -3.403601, 0.915719>, <3.029878, -0.749903, 0.083802>, 
      <-2.018834, 0.205732, 0.309815>, <-1.000000, 1.113369, 0.478488>, <2.218221, 1.157734, 0.478488>, <3.029878, 0.250097, 0.083802>, 
      <-2.018834, 1.205732, 0.309815>, <-1.000000, 1.205732, 0.064968>, <2.218221, 1.250097, 0.064968>, <3.029878, 1.250097, 0.083802>
    }
  }
  texture {
    Deep_Green
  }
  scale <75.0, 75.0, 60.0>
  rotate -180.0*z
  translate  <-59.1, -15.0, -18.8>
}


plane { // Ocean
  z,0
  texture {
    Water
  }
  scale <500.0, 500.0, 1.0>
  translate  <-12.6, 0.5, -13.4>
}


#declare DoorCuts2 = union {
  box { // DoorCut3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DarkOak
    }
    scale <1.2, 0.2, 1.0>
    translate  <1.845743, -16.792926, 13.988396>
  }
  box { // DoorCut4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DarkOak
    }
    scale <1.2, 0.2, 1.0>
    translate  <1.845743, -16.792926, 10.769066>
  }
}
difference { // DoorDone2
  box { // Door2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak
    }
    scale <1.7, 0.1, 3.0>
    translate  <1.845743, -16.54386, 12.42881>
  }
  object { DoorCuts2 }
  translate  -3.909882*x
}


#declare DoorCuts1 = union {
  box { // DoorCut1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DarkOak
    }
    scale <1.2, 0.2, 1.0>
    translate  <1.845743, -16.792926, 13.988396>
  }
  box { // DoorCut2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DarkOak
    }
    scale <1.2, 0.2, 1.0>
    translate  <1.845743, -16.792926, 10.769066>
  }
}
difference { // DoorDone1
  box { // Door1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFLightOak
    }
    scale <1.7, 0.1, 3.0>
    translate  <1.845743, -16.54386, 12.42881>
  }
  object { DoorCuts1 }
}


#declare StairCuts = union {
  object { StairCut1 }
  object { // StairCut2->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -0.4, -0.15>
  }
  object { // StairCut3->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -0.8, -0.3>
  }
  object { // StairCut4->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -1.2, -0.45>
  }
  object { // StairCut5->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -1.6, -0.6>
  }
  object { // StairCut6->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -2.0, -0.75>
  }
  object { // StairCut7->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -2.4, -0.9>
  }
  object { // StairCut8->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -2.8, -1.05>
  }
  object { // StairCut9->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -3.2, -1.2>
  }
  object { // StairCut10->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -3.6, -1.35>
  }
  object { // StairCut11->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -4.0, -1.5>
  }
  object { // StairCut12->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -4.4, -1.65>
  }
  object { // StairCut13->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -4.8, -1.8>
  }
  object { // StairCut14->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -5.2, -1.95>
  }
  object { // StairCut15->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -5.6, -2.1>
  }
  object { // StairCut16->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -6.0, -2.25>
  }
  object { // StairCut17->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -6.4, -2.4>
  }
  object { // StairCut18->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -6.8, -2.55>
  }
  object { // StairCut19->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -7.2, -2.7>
  }
  object { // StairCut20->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -7.6, -2.85>
  }
  object { // StairCut21->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -8.0, -3.0>
  }
  object { // StairCut22->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -8.4, -3.15>
  }
  object { // StairCut23->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -8.8, -3.3>
  }
  object { // StairCut24->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -9.2, -3.45>
  }
  object { // StairCut25->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -9.6, -3.6>
  }
  object { // StairCut26->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -10.0, -3.75>
  }
  object { // StairCut27->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -10.4, -3.9>
  }
  object { // StairCut28->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -10.8, -4.05>
  }
  object { // StairCut29->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -11.2, -4.2>
  }
  object { // StairCut30->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -11.6, -4.35>
  }
  object { // StairCut31->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -12.0, -4.5>
  }
  object { // StairCut32->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -12.4, -4.65>
  }
  object { // StairCut33->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -12.8, -4.8>
  }
  object { // StairCut34->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -13.2, -4.95>
  }
  object { // StairCut35->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -13.6, -5.1>
  }
  object { // StairCut36->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -14.0, -5.25>
  }
  object { // StairCut37->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -14.4, -5.4>
  }
  object { // StairCut38->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -14.8, -5.55>
  }
  object { // StairCut39->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -15.2, -5.7>
  }
  object { // StairCut40->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -15.6, -5.85>
  }
  object { // StairCut41->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -16.0, -6.0>
  }
  object { // StairCut42->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -16.4, -6.15>
  }
  object { // StairCut43->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -16.8, -6.3>
  }
  object { // StairCut44->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -17.2, -6.45>
  }
  object { // StairCut45->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -17.6, -6.6>
  }
  object { // StairCut46->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -18.0, -6.75>
  }
  object { // StairCut47->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -18.4, -6.9>
  }
  object { // StairCut48->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -18.8, -7.05>
  }
  object { // StairCut49->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -19.2, -7.2>
  }
  object { // StairCut50->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -19.6, -7.35>
  }
  object { // StairCut51->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -20.0, -7.5>
  }
  object { // StairCut52->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -20.4, -7.65>
  }
  object { // StairCut53->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -20.8, -7.8>
  }
  object { // StairCut54->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -21.2, -7.95>
  }
  object { // StairCut55->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -21.6, -8.1>
  }
  object { // StairCut56->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -22.0, -8.25>
  }
  object { // StairCut57->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -22.4, -8.4>
  }
  object { // StairCut58->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -22.8, -8.55>
  }
  object { // StairCut59->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -23.2, -8.7>
  }
  object { // StairCut60->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -23.6, -8.85>
  }
  object { // StairCut61->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -24.0, -9.0>
  }
  object { // StairCut62->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -24.4, -9.15>
  }
  object { // StairCut63->StairCut1
    StairCut1
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, -24.8, -9.3>
  }
  texture {
    CorkWhite
  }
  translate  <5.453868, -4.174465, 0.0>
}
difference { // StairsDone
  cone { // GroundBase
    <0,0,0>, 0.68, <0,0,1>, 1.0
    texture {
      CorkWhite
    }
    scale <64.0, 64.0, 11.2>
    rotate 180.0*x
    translate  <0.0, 0.041304, 9.625272>
  }
  object { StairCuts }
}


#declare FenceCuts = union {
  cylinder { // FenceCut1
    <0,0,1>, <0,0,0>, 1 
    texture {
      CorkWhite
    }
    scale <33.0, 33.0, 8.0>
    translate  9.268734*z
  }
  box { // FenceCut2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CorkWhite
    }
    scale <3.764341, 1.947287, 4.0>
    translate  <-0.04071, -33.708612, 13.318053>
  }
}
difference { // FenceDone
  cylinder { // Fence
    <0,0,1>, <0,0,0>, 1 
    texture {
      CorkWhite
    }
    scale <35.0, 35.0, 3.5>
    translate  9.558656*z
  }
  object { FenceCuts }
}




#declare TopPosts = union {
  object { TopRoomPost1 }
  object { // TopRoomPost2->TopRoomPost1
    TopRoomPost1
    translate  <4.056444, -0.806877, 0.0>
  }
  object { // TopRoomPost3->TopRoomPost1
    TopRoomPost1
    translate  <7.495332, -3.104668, 0.0>
  }
  object { // TopRoomPost4->TopRoomPost1
    TopRoomPost1
    translate  <9.793123, -6.543556, 0.0>
  }
  object { // TopRoomPost5->TopRoomPost1
    TopRoomPost1
    translate  <10.6, -10.6, 0.0>
  }
  object { // TopRoomPost6->TopRoomPost1
    TopRoomPost1
    translate  <9.793123, -14.656444, 0.0>
  }
  object { // TopRoomPost7->TopRoomPost1
    TopRoomPost1
    translate  <7.495332, -18.095332, 0.0>
  }
  object { // TopRoomPost8->TopRoomPost1
    TopRoomPost1
    translate  <4.056444, -20.393123, 0.0>
  }
  object { // TopRoomPost9->TopRoomPost1
    TopRoomPost1
    translate  <-0.0, -21.2, 0.0>
  }
  object { // TopRoomPost10->TopRoomPost1
    TopRoomPost1
    translate  <-4.056444, -20.393123, 0.0>
  }
  object { // TopRoomPost11->TopRoomPost1
    TopRoomPost1
    translate  <-7.495332, -18.095332, 0.0>
  }
  object { // TopRoomPost12->TopRoomPost1
    TopRoomPost1
    translate  <-9.793123, -14.656444, 0.0>
  }
  object { // TopRoomPost13->TopRoomPost1
    TopRoomPost1
    translate  <-10.6, -10.6, 0.0>
  }
  object { // TopRoomPost14->TopRoomPost1
    TopRoomPost1
    translate  <-9.793123, -6.543556, 0.0>
  }
  object { // TopRoomPost15->TopRoomPost1
    TopRoomPost1
    translate  <-7.495332, -3.104668, 0.0>
  }
  object { // TopRoomPost16->TopRoomPost1
    TopRoomPost1
    translate  <-4.056444, -0.806877, 0.0>
  }
  texture {
    White_Plaster
  }
  translate  -1.6*x
}
#declare RoofCut = difference {
  sphere { // Tier4Roof
    <0,0,0>,1
    scale <11.0, 11.0, 3.0>
    translate  <-1.5, 0.0, 13.1>
  }
  box { // TopRoofCut
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 2.0>
    translate  <-1.8, 0.0, 10.9>
  }
  texture {
    White_Plaster
  }
}
union { // Tier4
  object { TopPosts }
  cylinder { // GlassTop
    <0,0,1>, <0,0,0>, 1 
    texture {
      PaleBlueGlass
    }
    hollow
    scale <10.3, 10.3, 13.0>
    translate  <-1.6, -0.1, 0.0>
  }
  object { RoofCut }
  object { Chimney1 }
  object { // Chimney2->Chimney1
    Chimney1
    rotate <0.0, 0.0, -45.0>
  }
  object { // Chimney3->Chimney1
    Chimney1
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Chimney4->Chimney1
    Chimney1
    rotate <0.0, 0.0, -135.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Chimney5->Chimney1
    Chimney1
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Chimney6->Chimney1
    Chimney1
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Chimney7->Chimney1
    Chimney1
    rotate <0.0, 0.0, 90.0>
    translate  -0.0*y
  }
  object { // Chimney8->Chimney1
    Chimney1
    rotate <0.0, 0.0, 45.0>
    translate  <-0.0, -0.0, 0.0>
  }
  translate  143.1*z
}


union { // Tier2
  object { Oct1 }
  cone { // Roof1
    <0,0,0>, 0.68, <0,0,1>, 1.0
    texture {
      White_Plaster
    }
    scale <19.0, 19.0, 3.8>
    rotate 180.0*x
    translate  <0.0, 0.041304, 139.439533>
  }
  object { // Oct2->Oct1
    Oct1
    rotate -45.0*z
  }
  object { // Oct3->Oct1
    Oct1
    rotate -90.0*z
    translate  0.0*x
  }
  object { // Oct4->Oct1
    Oct1
    rotate -135.0*z
    translate  0.0*x
  }
  object { // Oct5->Oct1
    Oct1
    rotate 180.0*z
    translate  -0.0*y
  }
  object { // Oct6->Oct1
    Oct1
    rotate 135.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Oct7->Oct1
    Oct1
    rotate 90.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Oct8->Oct1
    Oct1
    rotate 45.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  translate  <-1.5, 0.0, 3.5>
}




sphere { // Moon
  <0,0,0>,1
  texture {
    MoonSurface
  }
  no_shadow
  scale 8.0
  translate  <40.7, 330.2, 220.9>
}


plane { // Sky
  z,0
  texture {
    NightSky
  }
  rotate -13.0*x
  translate  <0.0, -7.4, 630.7>
}


